////////////////////////////////////////////////////////////////////////////////
// Memory
////////////////////////////////////////////////////////////////////////////////
// Notes: need to optimize cpu_writemem20
//
//
//
//
//
//////////////////////////////////////////////////////////////////////////////

#include "../inc/rom.h"
#include "../inc/nec.h"
#include "../inc/io.h"
#include "../inc/gpu.h"

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
#define IO_ROM_BANK_BASE_SELECTOR	0xC0


UINT8	*ws_rom;
UINT8	*ws_staticRam;
UINT8	*internalRam;
UINT8	*externalEeprom;

UINT16	ws_rom_checksum;

UINT32	sramAddressMask;
UINT32	externalEepromAddressMask;
UINT32	romAddressMask;
UINT32  romSize;


////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void cpu_writemem20(UINT32 addr,UINT8 value)
{
	UINT32	offset=addr&0xffff;
	UINT32	bank=addr>>16;

	// 0 - RAM - 16 KB (WS) / 64 KB (WSC) internal RAM
	if (!bank)
	{
		ws_gpu_write_byte(offset,value);
		//TODO:AUDIO
		//		ws_audio_write_byte(offset,value);
	}
	else
	// 1 - SRAM (cart) 
	if (bank==1)
		ws_staticRam[offset&sramAddressMask]=value;

	// other banks are read-only
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
UINT8 cpu_readmem20(UINT32 addr)
{
	UINT32	offset=addr&0xffff;
	UINT32	bank=addr>>16;
	
	switch (bank)
	{
	case 0:		// 0 - RAM - 16 KB (WS) / 64 KB (WSC) internal RAM
				if (ws_gpu_operatingInColor)
					return(internalRam[offset]);
				else
				if (offset<0x4000)
					return(internalRam[offset]);
				return(0xff);

	case 1:  	// 1 - SRAM (cart) 
				return ws_staticRam[offset&sramAddressMask];
	case 2:
	case 3:		return ws_rom[offset+((ws_ioRam[IO_ROM_BANK_BASE_SELECTOR+bank]&((romSize>>16)-1))<<16)];
	default: 
				int romBank=(256-(((ws_ioRam[IO_ROM_BANK_BASE_SELECTOR]&0xf)<<4)|(bank&0xf)));
				return ws_rom[(unsigned)(offset+romSize-(romBank<<16))];
	}
	return(0xff);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void ws_memory_init(UINT8 *rom, UINT32 wsRomSize)
{
	ws_romHeaderStruct	*ws_romHeader;
	
	ws_rom=rom;
	romSize=wsRomSize;
	ws_romHeader=ws_rom_getHeader(ws_rom,romSize);
	ws_rom_checksum=ws_romHeader->checksum;
	internalRam=(UINT8*)malloc(0x10000);
	ws_staticRam=(UINT8*)malloc(0x10000); 
	externalEeprom=(UINT8*)malloc(131072);//ws_rom_eepromSize(ws_rom,romSize));
	sramAddressMask=ws_rom_sramSize(ws_rom,romSize)-1;
	externalEepromAddressMask=ws_rom_eepromSize(ws_rom,romSize)-1;
	romAddressMask=romSize-1;

	if (ws_romHeader->minimumSupportSystem==WS_SYSTEM_COLOR)
		ws_gpu_operatingInColor=1;

}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void ws_memory_reset(void)
{
	memset(internalRam,0,0x10000);
	memset(ws_staticRam,0,0x10000);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void ws_memory_done(void)
{
	free(ws_rom);
	free(ws_staticRam);
	free(internalRam);
	free(externalEeprom);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
UINT8	*memory_getRom(void)
{
	return(ws_rom);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
UINT32	memory_getRomSize(void)
{
	return(romSize);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
UINT16	memory_getRomCrc(void)
{
	return(ws_rom_checksum);
}

